﻿/**********************************
* @file adc.h
* @brief
* @author
* @version V0.0.0
* @date 2020.02.19
* @details 
* @copyright
* @note 
**********************************/

#ifndef  _ADC_H
#define  _ADC_H 

/* Includes 
------------------------------------------------------------------*/
#include "CSU38F20.h"
#include "isp.h"

/* Fuction Define -----------------------------------------------------------*/

/**
* @def SIG_AIN0
* @brief define channel SIG AIN0
* Details.
*/
#define  SIG_AIN0    0x00

/**
* @def SIG_AIN1
* @brief define channel SIG AIN1
* Details.
*/
#define  SIG_AIN1    0x10

/**
* @def SIG_AIN2
* @brief define channel SIG AIN2
* Details.
*/
#define  SIG_AIN2    0x20

/**
* @def SIG_AIN3
* @brief define channel SIG AIN3
* Details.
*/
#define  SIG_AIN3    0x30

/**
* @def SIG_AIN4
* @brief define channel SIG AIN4
* Details.
*/
#define  SIG_AIN4    0x40

/**
* @def SIG_AIN5
* @brief define channel SIG AIN5
* Details.
*/
#define  SIG_AIN5    0x50

/**
* @def SIG_AIN6
* @brief define channel SIG AIN6
* Details.
*/
#define  SIG_AIN6    0x60

/**
* @def SIG_AIN7
* @brief define channel SIG AIN7
* Details.
*/
#define  SIG_AIN7    0x70

/**
* @def SIG_1/8VDD
* @brief define channel SIG 1/8VDD
* Details.
*/
#define  SIG_1_8VDD    0xC0

/**
* @def SIG_VREF
* @brief define channel SIG VREF
* Details.
*/
#define  SIG_VREF    0xD0

/**
* @def SIG_GND
* @brief define channel SIG GND
* Details.
*/
#define  SIG_GND    0xE0

/**
* @def DIF_AIN0/AIN1
* @brief define channel DIF AIN0/AIN1
* Details.
*/
#define  DIF_AIN0_AIN1    0x01

/**
* @def DIF_AIN2/AIN3
* @brief define channel DIF AIN2/AIN3
* Details.
*/
#define  DIF_AIN2_AIN3    0x11

/**
* @def DIF_AIN4/AIN5
* @brief define channel DIF AIN4/AIN5
* Details.
*/
#define  DIF_AIN4_AIN5    0x21

/**
* @def DIF_AIN6/AIN7
* @brief define channel DIF AIN6/AIN7
* Details.
*/
#define  DIF_AIN6_AIN7    0x31

/**
* @def DIF_AIN0/VSSA
* @brief define channel DIF AIN0/VSSA
* Details.
*/
#define  DIF_AIN0_VSSA    0x41

/**
* @def DIF_AIN1/VSSA
* @brief define channel DIF AIN1/VSSA
* Details.
*/
#define  DIF_AIN1_VSSA    0x51

/**
* @def DIF_AIN2/VSSA
* @brief define channel DIF AIN2/VSSA
* Details.
*/
#define  DIF_AIN2_VSSA    0x61

/**
* @def DIF_AIN3/VSSA
* @brief define channel DIF AIN3/VSSA
* Details.
*/
#define  DIF_AIN3_VSSA    0x71

/**
* @def DIF_AIN4/VSSA
* @brief define channel DIF AIN4/VSSA
* Details.
*/
#define  DIF_AIN4_VSSA    0x81

/**
* @def DIF_AIN5/VSSA
* @brief define channel DIF AIN5/VSSA
* Details.
*/
#define  DIF_AIN5_VSSA    0x91

/**
* @def DIF_AIN6/VSSA
* @brief define channel DIF AIN6/VSSA
* Details.
*/
#define  DIF_AIN6_VSSA    0xA1

/**
* @def DIF_AIN7/VSSA
* @brief define channel DIF AIN7/VSSA
* Details.
*/
#define  DIF_AIN7_VSSA    0xB1

/**
* @def DIF_1/8VDD/VSSA
* @brief define channel DIF 1/8VDD/VSSA
* Details.
*/
#define  DIF_1_8VDD_VSSA    0xC1

/**
* @def DIF_VREF/VSSA
* @brief define channel DIF VREF/VSSA
* Details.
*/
#define  DIF_VREF_VSSA    0xD1

/**
* @def DIF_GND/VSSA
* @brief define channel DIF GND/VSSA
* Details.
*/
#define  DIF_GND_VSSA    0xE1

/* Fuction Define -----------------------------------------------------------*/

/**
* @def set_adc_clk()
* @brief set adc clk
* Details.
*/
#define set_adc_clk()            {SRADCKS_0 = 0; SRADCKS_1 = 1;}

/**
* @def set_adc_samp()
* @brief set adc samp
* Details.
*/
#define set_adc_samp()            {SRADACKS_0 = 0; SRADACKS_1 = 1;}

/**
* @def adc_enable()
* @brief enable adc function
* Details.
*/
#define adc_enable()             {SRADEN = 1;}

/**
* @def adc_channel()
* @brief enable adc channel
* Details.
*/
#define adc_channel(ch)              {SRADCON2 = ch;}

/**
* @def adc_start_conver() 
* @brief start adc conver
* Details.
*/
#define adc_start_conver()       {SRADS = 1;}

/**
* @def adc_int_enablet() 
* @brief adc conver interrupt enable
* Details.
*/
#define adc_int_enable()       {GIE = 1;SRADIE = 1;}
 
/* Exported functions 
--------------------------------------------------------*/

extern void adc_init(void);
extern unsigned int adc_get_result(unsigned char channel);



#endif